<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CheckoutOption;
use PaypalServerSdkLib\Models\ItemDetails;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\TaxAmount;

/**
 * Builder for model ItemDetails
 *
 * @see ItemDetails
 */
class ItemDetailsBuilder
{
    /**
     * @var ItemDetails
     */
    private $instance;

    private function __construct(ItemDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Item Details Builder object.
     */
    public static function init(): self
    {
        return new self(new ItemDetails());
    }

    /**
     * Sets item code field.
     *
     * @param string|null $value
     */
    public function itemCode(?string $value): self
    {
        $this->instance->setItemCode($value);
        return $this;
    }

    /**
     * Sets item name field.
     *
     * @param string|null $value
     */
    public function itemName(?string $value): self
    {
        $this->instance->setItemName($value);
        return $this;
    }

    /**
     * Sets item description field.
     *
     * @param string|null $value
     */
    public function itemDescription(?string $value): self
    {
        $this->instance->setItemDescription($value);
        return $this;
    }

    /**
     * Sets item options field.
     *
     * @param string|null $value
     */
    public function itemOptions(?string $value): self
    {
        $this->instance->setItemOptions($value);
        return $this;
    }

    /**
     * Sets item quantity field.
     *
     * @param string|null $value
     */
    public function itemQuantity(?string $value): self
    {
        $this->instance->setItemQuantity($value);
        return $this;
    }

    /**
     * Sets item unit price field.
     *
     * @param Money|null $value
     */
    public function itemUnitPrice(?Money $value): self
    {
        $this->instance->setItemUnitPrice($value);
        return $this;
    }

    /**
     * Sets item amount field.
     *
     * @param Money|null $value
     */
    public function itemAmount(?Money $value): self
    {
        $this->instance->setItemAmount($value);
        return $this;
    }

    /**
     * Sets discount amount field.
     *
     * @param Money|null $value
     */
    public function discountAmount(?Money $value): self
    {
        $this->instance->setDiscountAmount($value);
        return $this;
    }

    /**
     * Sets adjustment amount field.
     *
     * @param Money|null $value
     */
    public function adjustmentAmount(?Money $value): self
    {
        $this->instance->setAdjustmentAmount($value);
        return $this;
    }

    /**
     * Sets gift wrap amount field.
     *
     * @param Money|null $value
     */
    public function giftWrapAmount(?Money $value): self
    {
        $this->instance->setGiftWrapAmount($value);
        return $this;
    }

    /**
     * Sets tax percentage field.
     *
     * @param string|null $value
     */
    public function taxPercentage(?string $value): self
    {
        $this->instance->setTaxPercentage($value);
        return $this;
    }

    /**
     * Sets tax amounts field.
     *
     * @param TaxAmount[]|null $value
     */
    public function taxAmounts(?array $value): self
    {
        $this->instance->setTaxAmounts($value);
        return $this;
    }

    /**
     * Sets basic shipping amount field.
     *
     * @param Money|null $value
     */
    public function basicShippingAmount(?Money $value): self
    {
        $this->instance->setBasicShippingAmount($value);
        return $this;
    }

    /**
     * Sets extra shipping amount field.
     *
     * @param Money|null $value
     */
    public function extraShippingAmount(?Money $value): self
    {
        $this->instance->setExtraShippingAmount($value);
        return $this;
    }

    /**
     * Sets handling amount field.
     *
     * @param Money|null $value
     */
    public function handlingAmount(?Money $value): self
    {
        $this->instance->setHandlingAmount($value);
        return $this;
    }

    /**
     * Sets insurance amount field.
     *
     * @param Money|null $value
     */
    public function insuranceAmount(?Money $value): self
    {
        $this->instance->setInsuranceAmount($value);
        return $this;
    }

    /**
     * Sets total item amount field.
     *
     * @param Money|null $value
     */
    public function totalItemAmount(?Money $value): self
    {
        $this->instance->setTotalItemAmount($value);
        return $this;
    }

    /**
     * Sets invoice number field.
     *
     * @param string|null $value
     */
    public function invoiceNumber(?string $value): self
    {
        $this->instance->setInvoiceNumber($value);
        return $this;
    }

    /**
     * Sets checkout options field.
     *
     * @param CheckoutOption[]|null $value
     */
    public function checkoutOptions(?array $value): self
    {
        $this->instance->setCheckoutOptions($value);
        return $this;
    }

    /**
     * Initializes a new Item Details object.
     */
    public function build(): ItemDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
